% Function: This program is used to concatenate the reporter values from 
% two different cell arrays into a single cell, used to combine the data
% from two replicates

% Inputs:
% Cell_1 - a cell with dimensions (row = # Probes, col = # IPs), where each
%    entry contains the reporter values for each bead in the given IP-probe 
%    pair
% Cell_2 - a cell with the same dimensions as Cell_1 (row = # Probes, 
%    col = # IPs), where each entry contains the reporter values for each 
%    bead in the given IP-probe pair

% Outputs:
% ConcatCellOutput -  a cell with the same dimensions as Cell_1 & Cell_2,
%    where each entry has the combined reporter values from both cells
% N - This is a matrix with the same dimensions of the cells that returns
%    the combined length of the reporter values for each ip-probe pair, ie
%    number of total beads measured

function [ConcatCellOutput, N] = ConcatRep(Cell_1,Cell_2)

% determine the size of Cell_1 & Cell_2, where row = # probes and col = # 
% IPs 
[row,col] = size(Cell_1);


% initialize empty cell array and matrix of length(rows) -> probe & 
% width(cols) -> ips, to store the respective outputs
ConcatCellOutput = cell(row,col);
N = zeros(row,col);

% loop over the rows (Probes)
for i=1:row
     
    % loop over the cols (IPs)
    for j=1:col
    
        % store the length of the reporter data from the ith probe and jth
        % IP
        L1 = length(Cell_1{i,j});
        L2 = length(Cell_2{i,j});
        
        % create a list of length L1+L2 to store the concatenated reporter 
        % values 
        Concat_ij = zeros(L1+L2,1);
        
        % store the values from cell 1 in the first L1 entrys
        Concat_ij(1:L1) = Cell_1{i,j};
        % store the values from cell 2 in the remaining L2 entrys
        Concat_ij(L1+1:L1+L2) = Cell_2{i,j};
        
        % add the concatenated reporter value to the proper cell in the
        % output (ie IP-probe pair)
        ConcatCellOutput{i,j} = Concat_ij;
        
        % add the length information to the secondary output
        N(i,j) = L1+L2;
        
    end
    
    
end

        